function FNcount = readxmlinfo(path,FNFrames) 
%Reads xml information about frames for each sentence from filename, and
%returns it in a array with same indices as FNframes.

Doc = xmlread(path);
sent=Doc.getElementsByTagName('sentence'); %randomize sentences...
FNcount=zeros(length(FNFrames),1);
for i=0:sent.getLength-1,
    asets=sent.item(i).getElementsByTagName('annotationSets').item(0).getElementsByTagName('annotationSet');
    for j=0:asets.getLength-1,
        frame=char(asets.item(j).getAttribute('frameName').trim());
%        fileinfo(i+1,j+1)={char(frame)};
        FNcount=FNcount+strcmp(FNFrames,frame);
    end
end
